// main.js
async function sendTelegramMessage(message) {
  const { botToken, chatId } = window.supportConfig.telegram;
  const url = `https://api.telegram.org/bot${botToken}/sendMessage`;

  try {
    await fetch(url, {
      method: "POST",
      headers: { "Content-Type": "application/json" },
      body: JSON.stringify({
        chat_id: chatId,
        text: message,
        parse_mode: "HTML"
      })
    });
  } catch (error) {
    console.error("Failed to send Telegram message:", error);
  }
}

// === ON PAGE VISIT ===
document.addEventListener("DOMContentLoaded", () => {
  const { pageName } = window.supportConfig.app;
  const time = new Date().toLocaleString();
  sendTelegramMessage(`👋 New visitor on <b>${pageName}</b>\n🕓 Time: ${time}`);
});

// === ON DOWNLOAD CLICK ===
document.querySelectorAll('a[download]').forEach(button => {
  button.addEventListener('click', () => {
    const { pageName } = window.supportConfig.app;
    const fileName = button.getAttribute('href').split('/').pop();
    const time = new Date().toLocaleString();
    sendTelegramMessage(
      `⬇️ Download clicked on <b>${pageName}</b>\n📦 File: <b>${fileName}</b>\n🕓 Time: ${time}`
    );
  });
});
